# Deploy Mortgage Processing Flow via CloudFormation


This is a complete setup for an Amazon Bedrock Flow. The flow includes prompts, Lambda functions, and an Agent with an associated Knowledge base and Guardrail, alongside DynamoDB databases. This flow is meant to be a tutorial to get you quickly onboarded to understanding how different Amazon Bedrock resources work. To view the workshop on which this setup is based, see [https://catalog.us-east-1.prod.workshops.aws/workshops/1e5b6626-f63c-41d7-adcb-4a3cdfd279ac/en-US](https://catalog.us-east-1.prod.workshops.aws/workshops/1e5b6626-f63c-41d7-adcb-4a3cdfd279ac/en-US).

## Prerequisites:
- You have permissions to create an S3 bucket and upload files into it.
- You have permissions to use Amazon Bedrock API operations

## Solution Deployment:

### Step 1 : Prepare templates for deployment
`deploy.sh` script will create a S3 deployment bucket, upload the required artifacts it, and prepare the CloudFormation templates for deployment. 
         
         a.	If you run this script without [args], this will create a deployment bucket with default name - 'e2e-rag-deployment-${ACCOUNT_ID}-${AWS_REGION}'

         b.	If you run this script with [args], this will create a deployment bucket with the name provided in second args- '<BUCKET_NAME>-${ACCOUNT_ID}-${AWS_REGION}'

Run the included `deploy.sh` script as shown below:

    -  git clone https://github.com/aws-samples/amazon-bedrock-samples.git
    
    -  cd knowledge-bases/04-infrastructure/e2e-rag-deployment-using-bedrock-kb-cfn

    -  bash deploy.sh (For Windows users it may be different)

Once the deploy.sh script run is finished, proceed to the next step.

### Step 2 : Deploy stacks

Using the AWS Console:

    1. Go to the AWS CloudFormation Console, choose **Create stack** and then select **With new resources (standard).
    
    2. In the **Specify template** section, choose **Upload a template file** and choose the `main-stack.yaml`or `main-stack.json` file created by the deploy script. Then choose **Next**.

    3. Provide a **Stack name**. For the parameters, you can leave the default values or replace them with preferred values. If you change any of the knowledge base configurations, make sure that they are compatible with one another (for more information, see [https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup.html](https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup.html)). Then choose **Next**.

    4. In the **Stack failure options** section, choose **Delete all newly created resources**.
    
    5. In the **Capabilities** section, check off the acknoweldgments. Then choose **Next**.
    
    6. Review your configurations and then choose **Submit**.

## Testing the RAG Workflow

Deployment will take several minutes. After successful deployment, do the following:

1. Go to Amazon Bedrock Console and choose **Flows** in the left navigation pane.
1. In the **Flows** section, select the flow that you created.
1. Choose **Edit in flow builder**. You can drag individual nodes in the flow to modify the visual representation of the flow.
1. Try entering the following input in the **Test flow** pane and then choose **Run**:
    ```
    {
        "income": 80000, 
        "totalDebt": 5000, 
        "loanTerm": 30, 
        "loanAmount": 600000, 
        "creditScore": 750, 
        "mlsId": "MLS-5678"
    } 
    ```    
1. Then, try the following input:
    ```
    {
        "income": 120000, 
        "totalDebt": 5000, 
        "loanTerm": 30, 
        "loanAmount": 200000, 
        "creditScore": 650, 
        "mlsId": "MLS-3456"
    }    
    ```    